#!/bin/bash

TARGET_DISK=""
TARGET_PART=""
SYSTEM_BOOT="1"
DONT_ASK="0"

if [ -z $ROOT_LBL ] ; then
#    err_quit "ROOT_LBL not set, in $0, quitting"
	ROOT_LBL=VOYAGE_FS
fi

# no here-document here. 
# this may be called from a read-only (live) file system
# where the mandatory tmp file for here-douments can't be 
# created. ottherwise you may get:
# "cannot create temp file for here document: Read-only file system"
usage () {
	echo "$0 -t <disk> [ -b { 1 | 2 | 3 | 4 } ] [ -y ]"
	echo "    -t  target disk device"
	echo "    -b  target partition number (default: 1)"
	echo "    -y  don't prompt for confirmance (default: prompt)"
	echo "legacy mode:"
	echo "$0 <device>"
	echo ""
}


#
# usage:
#	doopt "$@"
#
# returns:
#	$TARGET_DISK
#	$SYSTEM_BOOT
#	$DONT_ASK
#
doopt () {
	# for backward compatibility	
	if [ $# = 1 ]; then 
		TARGET_DISK="$1"
		TARGET_PART="$TARGET_DISK"
		return;
	fi

	local x
	while [ $# -gt 0 ]; do
		x="$1"; shift

		case "$x" in 
		-t) TARGET_DISK="$1"
			shift
			;;
		-b) SYSTEM_BOOT="$1"
			shift
			;;
		-y) DONT_ASK=1
			;;
		*) usage
			exit 1
			;;
		esac
	done
}

doopt "$@"

if [ -z "$SYSTEM_BOOT" -o -z "$TARGET_DISK" ]; then 
	usage
	exit 1
fi 

if [ "$DONT_ASK" = 0 ]; then 
	echo "Press ENTER to continue to format flash memory on $TARGET_DISK"
	read a
fi

TARGET_PART=$TARGET_DISK$SYSTEM_BOOT
TARGET_PART_MMC="$TARGET_DISK"p"$SYSTEM_BOOT"
case "$SYSTEM_BOOT" in
	1) SFDISKCMD='0,,L,*\n;\n;\n;'
	   ;;
	2) SFDISKCMD='0,0,\n0,,L,*\n;\n;'
	   ;;
	3) SFDISKCMD='0,0,\n0,0,\n0,,L,*\n;'
	   ;;
	4) SFDISKCMD='0,0,\n0,0,\n0,0,\n0,,L,*'
	   ;;
	*) usage
           exit 1
	   ;;
esac
	

[ -b "$TARGET_DISK" ] && echo -e "$SFDISKCMD" | sfdisk "$TARGET_DISK"
sleep 1
[ -b "$TARGET_PART" ] && { 
	mkfs.ext2 -F $TARGET_PART
	tune2fs -i 0 -c 0 $TARGET_PART -L $ROOT_LBL
}
[ -b "$TARGET_PART_MMC" ] && { 
	mkfs.ext2 -F $TARGET_PART_MMC
	tune2fs -i 0 -c 0 $TARGET_PART_MMC -L $ROOT_LBL
}
