package Zaptel::Hardware;
#
# Written by Oron Peled <oron@actcom.co.il>
# Copyright (C) 2007, Xorcom
# This program is free software; you can redistribute and/or
# modify it under the same terms as Perl itself.
#
# $Id: Hardware.pm 5134 2007-12-13 21:44:20Z oron $
#
use strict;
use Zaptel::Hardware::USB;
use Zaptel::Hardware::PCI;

sub device_detected($$) {
	my $dev = shift || die;
	my $name =  shift || die;
	die unless defined $dev->{'BUS_TYPE'};
	$dev->{IS_ASTRIBANK} = 0 unless defined $dev->{'IS_ASTRIBANK'};
	$dev->{'HARDWARE_NAME'} = $name;
}

sub device_removed($) {
	my $dev = shift || die;
	my $name = $dev->hardware_name;
	die "Missing zaptel device hardware name" unless $name;
}

sub device_list($) {
	my $self = shift || die;
	my @types = @_;
	my @list;

	@types = qw(USB PCI) unless @types;
	foreach my $t (@types) {
		@list = ( @list, @{$self->{$t}} );
	}
	return @list;
}

sub drivers($) {
	my $self = shift || die;
	my @devs = $self->device_list;
	my @drvs = map { $_->{DRIVER} } @devs;
	# Make unique
	my %drivers;
	@drivers{@drvs} = 1;
	return sort keys %drivers;
}

sub scan($) {
	my $pack = shift || die;
	my $self = {};
	bless $self, $pack;

	$self->{USB} = [ Zaptel::Hardware::USB->devices ];
	$self->{PCI} = [ Zaptel::Hardware::PCI->scan_devices ];
	return $self;
}

1;
