package Zaptel::Config::Defaults;
#
# Written by Oron Peled <oron@actcom.co.il>
# Copyright (C) 2007, Xorcom
# This program is free software; you can redistribute and/or
# modify it under the same terms as Perl itself.
#
# $Id: Defaults.pm 4462 2007-08-02 14:32:18Z oron $
#
use strict;

# Use the shell to source a file and expand a given list
# of variables.
sub do_source($@) {
	my $file = shift;
	my @vars = @_;
	my @output = `env -i sh -ec '. $file; export @vars; for i in @vars; do eval echo \$i=\\\$\$i; done'`;
	die "$0: Sourcing '$file' exited with $?" if $?;
	my %vars;
	
	foreach my $line (@output) {
		chomp $line;
		my ($k, $v) = split(/=/, $line, 2);
		$vars{$k} = $v if grep /^$k$/, @vars;
	}
	return %vars;
}

1;
