<?php
/*
 *  Copyright (C) 2008 Libelium Comunicaciones Distribuidas S.L.
 *  http://www.libelium.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  Version 0.1
 *  Author: Octavio Benedi Sanchez
 */
function make_olsrd()
{
    global $url_plugin;
    global $section;
    global $plugin;
    $data=Array();
    $path='/etc/olsrd/olsrd.conf';
    if (file_exists($path))
    {
        $data=parse_olsrd($path);
    }
	$list='
        <div class="title">OLSR configuration</div>

        <div class="plugin_content">
            <a class="btext" href="http://'.$_SERVER['HTTP_HOST'].':'.$data['LoadPlugin']['olsrd_httpinfo.so.0.1']['PlParam']['port'].'">Access OLSR summary</a>
        </div>
        <div class="title2">Interfaces</div>
        <form id="olsr" name="olsr">
        
        <div class="plugin_content">
            <table border="0" cellpadding="2" cellspacing="2">
			  <tbody>
			    <tr>';
    if($data['Interface']['interfaces']['eth0'])
	{
		$list.='<td>eth0 <input id="eth0" name="eth0" type="checkbox" checked></td>';
	}
	else
	{
		$list.='<td>eth0 <input id="eth0" name="eth0" type="checkbox"></td>';
	}
	if($data['Interface']['interfaces']['ath0'])
	{
		$list.='<td>ath0 <input id="ath0" name="ath0" type="checkbox" checked></td>';
	}
	else
	{
		$list.='<td>ath0 <input id="ath0" name="ath0" type="checkbox"></td>';
	}
	if($data['Interface']['interfaces']['ath1'])
	{
		$list.='<td>ath1 <input id="ath1" name="ath1" type="checkbox" checked></td>';
	}
	else
	{
		$list.='<td>ath1 <input id="ath1" name="ath1" type="checkbox"></td>';
	}
	$list.='
            </tr></tbody></table>
            </div>
            <div class="title2">OLSR access</div>
            <div class="plugin_content">
            <table class="main_table" border="0" cellpadding="2" cellspacing="2">
            <tbody>                
	  		    <tr>
			       <td>Autodetect Changes</td>
			       <td>
				      <select id="AutoDetectChanges" name="AutoDetectChanges">';

	if($data['Interface']['AutoDetectChanges']=='yes')
	{
		$list.='<option value="yes" selected="yes">Yes</option>
				<option value="no">No</option>
				';
	}
	else
	{
		$list.='<option value="yes">Yes</option>
				<option value="no" selected="yes">No</option>
				';
	}
	$list.='
					  </select>
			       </td>			       
			       <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'AutoDetectChanges [yes|no]:Olsrd  can  autodetect  changes  in  interface   configurations( polling on the interval set by NicChgsPollInt ). This is Enabled by default but can be turned off pr. NIC to save CPU cycles.\');"></td>
                   <td>[yes|no]</td>
			    </tr>
			    <tr>
			    	<td>HelloInterval</td>
			    	<td><input type="text" class="ms_float" id="HelloInterval" name="HelloInterval"';
	if ($data['Interface']['HelloInterval'])
	{
		$list.=' value="'.$data['Interface']['HelloInterval'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'HelloInterval [0.0-]:Sets the interval on which HELLO messages will be generated  and transmitted on this interface.\');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="HelloInterval_ms_cte"></div></td>
			    </tr>
			    <tr>
			    	<td>HelloValidityTime</td>
			    	<td><input type="text" class="ms_float" id="HelloValidityTime" name="HelloValidityTime"';
	if ($data['Interface']['HelloValidityTime'])
	{
		$list.=' value="'.$data['Interface']['HelloValidityTime'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'HelloValidityTime [0.0-]:Sets  the validity time to be announced in HELLO messages generated by this host on this interface. This value must  be  larger than  than  the  HELLO  generation  interval  to make any sense.Defaults to 3 * the generation interval.\');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="HelloValidityTime_ms_cte"></div></td>
			    </tr>
			    <tr>
			    	<td>TcInterval</td>
			    	<td><input type="text" class="ms_float" id="TcInterval" name="TcInterval"';
	if ($data['Interface']['TcInterval'])
	{
		$list.=' value="'.$data['Interface']['TcInterval'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'TcInterval [0.0-]:Sets the interval on which TC messages  will  be  generated  and transmitted on this interface.\');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="TcInterval_ms_cte"></div></td>
                </tr>
			    <tr>
			    	<td>TcValidityTime</td>
			    	<td><input type="text" class="ms_float" id="TcValidityTime" name="TcValidityTime"';
	if ($data['Interface']['TcValidityTime'])
	{
		$list.=' value="'.$data['Interface']['TcValidityTime'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'TcValidityTime [0.0-]:Sets  the validity time to be announced in TC messages generated by this host on this interface. This value must be  larger  than than the TC generation interval to make any sense. Defaults to 3 * the generation interval.\');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="TcValidityTime_ms_cte"></div></td>
			    </tr>
			    <tr>
			    	<td>MidInterval</td>
			    	<td><input type="text" class="ms_float" id="MidInterval" name="MidInterval"';
	if ($data['Interface']['MidInterval'])
	{
		$list.=' value="'.$data['Interface']['MidInterval'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'MidInterval [0.0-]:Sets the interval on which MID messages will  be  generated  and transmitted on this interface. \');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="MidInterval_ms_cte"></div></td>
			    </tr>
			    <tr>
			    	<td>MidValidityTime</td>
			    	<td><input type="text" class="ms_float" id="MidValidityTime" name="MidValidityTime"';
	if ($data['Interface']['MidValidityTime'])
	{
		$list.=' value="'.$data['Interface']['MidValidityTime'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'MidValidityTime [0.0-]:Sets the validity time to be announced in MID messages generated by this host on this interface. This value must be  larger  than than  the MID generation interval to make any sense. Defaults to 3 * the generation interval.\');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="MidValidityTime_ms_cte"></div></td>
			    </tr>
			    <tr>
			    	<td>HnaInterval</td>
			    	<td><input type="text" class="ms_float" id="HnaInterval" name="HnaInterval"';
	if ($data['Interface']['HnaInterval'])
	{
		$list.=' value="'.$data['Interface']['HnaInterval'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'HnaInterval [0.0-]:Sets the interval on which HNA messages will  be  generated  and transmitted on this interface.\');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="HnaInterval_ms_cte"></div></td>
			    </tr>
			    <tr>
			    	<td>HnaValidityTime</td>
			    	<td><input type="text" class="ms_float" id="HnaValidityTime" name="HnaValidityTime"';
	if ($data['Interface']['HnaValidityTime'])
	{
		$list.=' value="'.$data['Interface']['HnaValidityTime'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'HnaValidityTime [0.0-]:Sets the validity time to be announced in HNA messages generated by this host on this interface. This value must be  larger  than than  the HNA generation interval to make any sense. Defaults to 3 * the generation interval.\');"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="HnaValidityTime_ms_cte"></div></td>
			    </tr>
			    <tr>
			    	<td>Weight</td>
			    	<td><input type="text" class="ms_numerical" id="Weight" name="Weight"';
	if ($data['Interface']['Weight'])
	{
		$list.=' value="'.$data['Interface']['Weight'].'"';
	}
	$list.='
			    	></td>
			      	<td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'Weight [0-]: When multiple links exist between hosts the weight of the interface  is  used  to  determine the link to route by. Normally the weight is automatically calculated by olsrd based on the characteristics  of  the  interface,  but here you can specify a fixed value. Olsrd will choose links with the lowest value.\');"></td>
			      	<td>[0-]</td>
                </tr>
                <tr>
                    <td ></td>
                    <td colspan="3"><div id="Weight_ms_cte"></div></td>
			    </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="_ms_cte"></div></td>
			    </tr>                
			    <tr>
			      <td>IpVersion</td>
			      <td>
				      <select id="IpVersion" name="IpVersion">';

	if($data['IpVersion']==4)
	{
		$list.='<option value="4" selected="yes">4</option>
				<option value="6">6</option>
				';
	}
	else
	{
		$list.='<option value="4">4</option>
				<option value="6" selected="yes">6</option>
				';
	}
	$list.='
					  </select>
			      </td>			      
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'IpVersion: Olsrd supports both IP version 4 and  6.  This  option  controls what IP version olsrd is to use. Defaults to 4.\');"></td>
                  <td></td>
			    </tr>
			    <tr>
			      <td>AllowNoInt</td>
			      <td>
				      <select id="AllowNoInt" name="AllowNoInt">';

	if($data['AllowNoInt']=='yes')
	{
		$list.='<option value="yes" selected="yes">Yes</option>
				<option value="no">No</option>
					  ';
	}
	else
	{
		$list.='<option value="yes">Yes</option>
				<option value="no" selected="yes">No</option>
					  ';
	}
	$list.='
					  </select>
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'AllowNoInt: Olsrd  supports  dynamic  configuration  of  network interfaces. This means that interfaces on which olsrd runs, can be reconfigured  and olsrd will update itself with no need to be restarted. Olsrd also supports removal and addittion of interfaces in run time.  This  option specifies if olsrd should keep running if nonetwork interfaces are available. Defaults to yes.\');"></td>
			      <td></td>
			    </tr>
			    <tr>
			      <td>TosValue</td>
			      <td><input type="text" class="ms_numerical" id="TosValue" name="TosValue" ';
	if ($data['TosValue'])
	{
		$list.=' value="'.$data['TosValue'].'"';
	}
	$list.='
				></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'TosValue: This value controls the type of service value to set in  the  IP header of OLSR control traffic. Defaults to 16.\');"></td>
			      <td>[0-16]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="TosValue_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>Willingness</td>
			      <td><input type="text" class="ms_numerical" id="Willingness" name="Willingness" ';
	if ($data['Willingness'])
	{
		$list.=' value="'.$data['Willingness'].'"';
	}
	$list.='
				></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'Willingness: Nodes participating in a OLSR routed network will announce their willingness to act as relays for OLSR control traffic for  their neighbors. This option specifies a fixed willingness value to be announced by the local node.  4 is a neutral option here,  while 0  specifies  that  this  node  will never act as a relay, and 7 specifies that this node will always act as  such  a  relay.  If this  option  is  not  set in the configuration file, then olsrd will try to retrieve information  about  the  system  power  and dynamically  update  willingness  according  to this info. If no such info can be retrieved willingness is set to 4.\');"></td>
			      <td>[0-7]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="Willingness_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>UseHysteresis</td>
			     <td>
				      <select id="UseHysteresis" name="UseHysteresis">';

	if($data['UseHysteresis']=='yes')
	{
		$list.='<option value="yes" selected="yes">Yes</option>
				<option value="no">No</option>
					  ';
	}
	else
	{
		$list.='<option value="yes">Yes</option>
				<option value="no" selected="yes">No</option>
					  ';
	}
	$list.='
					  </select>
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'UseHysteresis: If set to yes hysteresis will be used as explained in section 14 of RFC3626.\');"></td>
			      <td></td>
			    </tr>
			    <tr>
			      <td>HystScaling</td>
			      <td><input type="text" class="ms_float" id="HystScaling" name="HystScaling" ';
	if ($data['HystScaling'])
	{
		$list.=' value="'.$data['HystScaling'].'"';
	}
	$list.='
				></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'HystScaling: Sets  the  scaling  value used by the hysteresis algorithm. This must be a positive floating point value smaller than  1.0.  Consult RFC3626 for details. The default value is 0.5.\');"></td>
                  <td>[0.01-0.99]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="HystScaling_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>HysThrLow</td>
			      <td><input type="text" class="ms_float" id="HysThrLow" name="HysThrLow" ';
	if ($data['HysThrLow'])
	{
		$list.=' value="'.$data['HysThrLow'].'"';
	}
	$list.='
				></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'HysThrLow: this  option  sets  the  upper threshold for accepting a link in hysteresis calculation.  The value must be higher than  the  one set as the lower threshold. Defaults to 0.8.\');"></td>
                  <td>[0.01-HystThrHigh]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="HysThrLow_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>HystThrHigh</td>
			      <td><input type="text" class="ms_float" id="HystThrHigh" name="HystThrHigh" ';
	if ($data['HystThrHigh'])
	{
		$list.=' value="'.$data['HystThrHigh'].'"';
	}
	$list.='
				></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'HystThrHigh: This option sets the lower threshold for setting a link to asymmetric using hysteresis.  The value must be lower than  the  one set as the upper threshold. Defaults to 0.3.\');"></td>
			      <td>[HystThrLow-0.99]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="HystThrHigh_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>Pollrate</td>
			      <td><input type="text" class="ms_float" id="Pollrate" name="Pollrate" ';
	if ($data['Pollrate'])
	{
		$list.=' value="'.$data['Pollrate'].'"';
	}
	$list.='
				></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'Pollrate: This  option sets the interval, in seconds, that the olsrd event scheduler should be set to poll. A setting of 0.2 will set olsrd to poll for events every 0.2 seconds.  Defaults to 0.1\');"></td>
			      <td>[0.1-10.0]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="Pollrate_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>NicChgsPollInt</td>
			      <td><input type="text" class="ms_float" id="NicChgsPollInt" name="NicChgsPollInt"';
	if ($data['NicChgsPollInt'])
	{
		$list.=' value="'.$data['NicChgsPollInt'].'"';
	}
	$list.='
				></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'NicChgsPollInt: This option sets the interval, in seconds, that olsrd will check the  configured  interfaces  for   changes   in   configuration. Defaults to 2.5.\');"></td>
			      <td>[0.1-100.0]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="NicChgsPollInt_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>TcRedundancy</td>
			      <td>
				      <select id="TcRedundancy" name="TcRedundancy">';

	if ($data['TcRedundancy']=='0')
	{
		$list.='
						<option value="0" selected="yes">0</option>
						<option value="1">1</option>
						<option value="2">2</option>
					  ';
	}
	elseif ($data['TcRedundancy']=='1')
	{
		$list.='
						<option value="0">0</option>
						<option value="1" selected="yes">1</option>
						<option value="2">2</option>
					  ';
	}
	else
	{
		$list.='
						<option value="0">0</option>
						<option value="1">1</option>
						<option value="2" selected="yes">2</option>
					  ';
	}
	$list.='
					  </select>
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'TcRedundancy: This  value controls the TC redundancy used by the local node in TC message generation.  To enable a more robust understanding of the  topology, nodes can be set to announce more than just their MPR selector set in TC messages.  If set  to  0  the  advertised link set of the node is limited to the MPR selectors.  If set to 1 the advertised link set of the node is the union  of  its  MPR set  and  its  MPR selector set. Finally, if set to 2 the advertised link set of the node is the full symmetric neighbor set of the node.  Defaults to 0.\');"></td>
			      <td></td>
			    </tr>
			    <tr>
			      <td>MprCoverage</td>
			      <td><input type="text" class="ms_numerical" id="MprCoverage" name="MprCoverage" ';
	if ($data['MprCoverage'])
	{
		$list.=' value="'.$data['MprCoverage'].'"';
	}
	$list.='
				  ></td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'MprCoverage: This value decides how many MPRs a node should attempt to select for every two hop neighbor. Defaults to 1 , and any  other  setting will severly reduce the optimization introduced by the MPR secheme!\');"></td>
			      <td>[1-]</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="MprCoverage_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>LinkQualityLevel</td>
			      <td>
				      <select id="LinkQualityLevel" name="LinkQualityLevel">';

	if ($data['LinkQualityLevel']=='2')
	{
		$list.='
						<option value="0">0</option>
						<option value="1">1</option>
						<option value="2" selected="yes">2</option>
					  ';
	}
	elseif ($data['LinkQualityLevel']=='1')
	{
		$list.='
						<option value="0">0</option>
						<option value="1" selected="yes">1</option>
						<option value="2">2</option>
					  ';
	}
	else
	{
		$list.='
						<option value="0" selected="yes">0</option>
						<option value="1">1</option>
						<option value="2">2</option>
					  ';
	}
	$list.='
					  </select>
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'LinkQualityLevel: This setting decides the Link Quality scheme to use. If set to 0 link  quality  is not regarded and olsrd runs in RFC3626 mode. If set to 1 link quality is used when calculating MPRs. If  set to  2  routes  will also be calculated based on distributed link quality information.  Note that a  setting  of  1  or  2  breaks RFC3626  compability! This option should therefore only be set to 1 or 2 if such a setting is used by all other  nodes  in  the network.\');"></td>
			      <td></td>
			    </tr>
			    <tr>
			      <td>LinkQualityWinSize</td>
			      <td><input type="text" class="ms_numerical" id="LinkQualityWinSize" name="LinkQualityWinSize"';
	if ($data['LinkQualityWinSize'])
	{
		$list.=' value="'.$data['LinkQualityWinSize'].'"';
	}
	$list.='
				  ></td>
			      <td class="help_image"></td>
			      <td>def. 100</td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="3"><div id="LinkQualityWinSize_ms_cte"></div></td>
			    </tr>
			    <tr>
			      <td>LinkQualityFishEye</td>
			      <td>
				      <select id="LinkQualityFishEye" name="LinkQualityFishEye">';

	if ($data['LinkQualityFishEye']=='1')
	{
		$list.='
						<option value="0">0</option>
						<option value="1" selected="yes">1</option>
					  ';
	}
	else
	{
		$list.='
						<option value="0" selected="yes">0</option>
						<option value="1">1</option>
					  ';
	}
	$list.='
					  </select>
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'LinkQualityFishEye: Enables(1) or disables(0) use of the experimental Fish Eye algorithm\');"></td>
			      <td></td>
			    </tr>
			    <tr>
			      <td>LinkQualityDijkstraLimit Hops</td>
                  <td> <input type="text" class="ms_numerical" id="LinkQualityDijkstraLimit1" name="LinkQualityDijkstraLimit1" maxlength="2" size="2"';
    if($data['LinkQualityDijkstraLimit'])
    {
        $aux1=explode(' ',trim($data['LinkQualityDijkstraLimit']));
    }
	if ($aux1[0])
	{
		$list.=' value="'.$aux1[0].'"';
	}
	$list.='
				  ></td>
                    <td class="help_image"></td>
			      	<td>[0-]</td>
                </tr>
                <tr>
                    <td ></td>
                    <td colspan="3"><div id="LinkQualityDijkstraLimit1_ms_cte"></div></td>
			    </tr>
                <tr>
                    <td>LinkQualityDijkstraLimit interval</td><td> <input type="text" class="ms_float" id="LinkQualityDijkstraLimit2" name="LinkQualityDijkstraLimit2" maxlength="4" size="4"';
	if ($aux1[1])
	{
		$list.=' value="'.$aux1[1].'"';
	}
	$list.='
				  ></td>
                    <td class="help_image"></td>
			      	<td>[0.0-]</td>
                </tr>
                <tr>
                    <td ></td>
                    <td colspan="3"><div id="LinkQualityDijkstraLimit2_ms_cte"></div></td>
			    </tr>
			    </tbody></table></div>
                <div class="title2">IpcConnect</div>
                <div class="plugin_content">
                <table><tbody>
			      <td class="subtable">
			        <table class="subtable" border="0" cellpadding="2" cellspacing="2" >
					  <tbody>
					    <tr>
					       <td>MaxConnections</td>
					       <td><input type="text" class="ms_numerical" id="IpcConnect_MaxConnections" name="IpcConnect_MaxConnections"';
	if ($data['IpcConnect']['MaxConnections'])
	{
		$list.=' value="'.$data['IpcConnect']['MaxConnections'].'"';
	}
	$list.=' maxlength="1" size="1"></td>
					       <td>[0-5]</td>
					    </tr>
                            <td></td>
                            <td colspan="3"><div id="IpcConnect_MaxConnections_ms_cte"></div></td>
					    <tr>
					    </tr>
					    <tr>
					    	<td colspan=3 rowspan=1>
					    	Hosts<td><input id="ipchcount" name="ipchcount" value="'.$data['IpcConnect']['ipchit'].'" type="hidden"></td>
					    	</td>
					    <tr>';
                        if($data['IpcConnect']['ipchit'])
                        {
                            for ($it=0;$it<$data['IpcConnect']['ipchit'];$it++)
                            {
                                $list.='
                                <tr>
                               <td class="nl">Host</td>
                               <td><input type="text" class="ms_ip" id="ipchost'.$it.'" name="ipchost'.$it.'" value="'.$data['IpcConnect']['Host'][$it].'" maxlength="15" size="15"></td>
                               <td></td>
                               </tr>
                               <tr>
                                <td></td>
                                <td><div id="ipchost'.$it.'_ms_cte"></div></td>
                               </tr>
                                ';
                            }
                        }
	$list.='
					    <tr>
					       <td class="nl">Host</td>
					       <td><input type="text" class="ms_ip" id="ipchost'.$it.'" name="ipchost'.$it.'" maxlength="15" size="15"></td>
					       <td></td>
					    </tr>
                        <tr>
                                <td></td>
                                <td><div id="ipchost'.$it.'_ms_cte"></div></td>
                               </tr>
						<tr>
						    <td colspan=3 rowspan=1>
					    	Nets
					    	</td>
					    <tr>
					       <td class="nl">Net Address</td>
					       <td>Netmask</td>
					       <td><input id="ipcncount" name="ipcncount" value="'.$data['IpcConnect']['ipcnit'].'" type="hidden"></td>
					    </tr>';
                        if($data['IpcConnect']['ipcnit'])
                        {
                            for ($it=0;$it<$data['IpcConnect']['ipcnit'];$it++)
                            {
                                $list.='
                               <tr>
                                <td class="nl"><input type="text" class="ms_subnet" id="IpcConnect_netaddress'.$it.'" name="IpcConnect_netaddress'.$it.'" value="'.$data['IpcConnect']['Net'][$it]['0'].'" maxlength="15" size="15"></td>
                                <td><input type="text" class="ms_ip" id="IpcConnect_netmask'.$it.'" name="IpcConnect_netmask'.$it.'" value="'.$data['IpcConnect']['Net'][$it]['1'].'" maxlength="15" size="15"></td>
                                <td></td>
                               </tr>
                               <tr>
                                <td class="nl"><div id="IpcConnect_netaddress'.$it.'_ms_cte"></div></td>
                                <td><div id="IpcConnect_netmask'.$it.'_ms_cte"></div></td>
                               </tr>
                                ';
                            }
                        }
	$list.='
						<tr>
					    	<td class="nl"><input type="text" class="ms_subnet" id="IpcConnect_netaddress'.$it.'" name="IpcConnect_netaddress'.$it.'" maxlength="15" size="15"></td>
					        <td><input type="text" class="ms_ip" id="IpcConnect_netmask'.$it.'" name="IpcConnect_netmask'.$it.'" maxlength="15" size="15"></td>
					        <td></td>
					    </tr>
                        <tr>
                                <td class="nl"><div id="IpcConnect_netaddress'.$it.'_ms_cte"></div></td>
                                <td><div id="IpcConnect_netmask'.$it.'_ms_cte"></div></td>
                               </tr>
						<tr>
					    </tr>
					  </tbody>
					</table>			      
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'IpcConnect: Olsrd  can allow processes to make a TCP connection to itself on which data regarding the topology will be transmitted.  This  is typically  used  by  GUI applications to provide a user-friendly front-end to olsrd. This option block  controls  thees  kind  of connections. MaxConnections  [0-5] This option specifies how many connections that can exist simoultneously.  Multiple  connections  have  not been  tested, and does not work! This option should only be used to control wheter or not processes can connect to olsrd by  setting it either to 0, which will tell olsrd not to allow any connections, or by setting it to a positive value. Defaults to 0. Host [IPv4 address] This option specifies a single host that is allowed  to  connect to  olsrd.   By  default only the loopback address(127.0.0.1) is set to be allowed. So if you want to be  able  to  connect  from another  host  you  should  add  it  here.   This  option can be repeated to add multiple hosts. Net [IPv4 netaddress] [IPv4 netmask] Here you can specify an entire netrange of  IP  addresses  which olsrd  will  allow  TCP  connections  from.  This  option can be repeated to add multiple networks. \');"></td>
                </tr>
                </tbody></table></div>
                <div class="title2">Hna4</div>
                <div class="plugin_content">
                <table><tbody>
			    <tr>
			      <td class="subtable">
			      <table border="0" cellpadding="2" cellspacing="2" >
					  <tbody>
					    <tr>
					       <td>Net Address</td>
					       <td>Netmask</td>
					       <td><input id="hna4count" name="hna4count" value="'.$data['Hna4']['count'].'" type="hidden"></td>
					    </tr>';
                        if($data['Hna4']['count'])
                        {
                            for ($it=0;$it<$data['Hna4']['count'];$it++)
                            {
                                $list.='
                               <tr>
                                <td><input type="text" class="ms_subnet" id="hna4_netaddress'.$it.'" name="hna4_netaddress'.$it.'" value="'.$data['Hna4']['netaddress'][$it].'" maxlength="15" size="15"></td>
                                <td><input type="text" class="ms_ip" id="hna4_netmask'.$it.'" name="hna4_netmask'.$it.'" value="'.$data['Hna4']['netmask'][$it].'" maxlength="15" size="15"></td>
                                <td></td>
                               </tr>
                               <tr>
                                <td><div id="hna4_netaddress'.$it.'_ms_cte"></div></td>
                                <td><div id="hna4_netmask'.$it.'_ms_cte"></div></td>
                               </tr>
                                ';
                            }
                        }
	$list.='
					    <tr>
					      <td><input type="text" class="ms_subnet" id="hna4_netaddress'.$it.'" name="hna4_netaddress'.$it.'" maxlength="15" size="15"></td>
					      <td><input type="text" class="ms_ip" id="hna4_netmask'.$it.'" name="hna4_netmask'.$it.'" maxlength="15" size="15"></td>
					      <td></td>
					    </tr>
                        <tr>
                                <td><div id="hna4_netaddress'.$it.'_ms_cte"></div></td>
                                <td><div id="hna4_netmask'.$it.'_ms_cte"></div></td>
                               </tr>
					  </tbody>
					</table>			      
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'Hna4: Hosts in a OLSR routed  network  can  announce  connecitivty  to external  networks  using HNA messages. This optionblock is used to set the IPv4 nteworks to be announced by this host. [IPv4 netaddress] [IPv4 netmask] Specifies a IPv4 network to announce in HNA  messages.  Multiple entries  can  be  added.  To  announce Internet connectivity set 0.0.0.0 0.0.0.0\');"></td>
                  </tr>
</tbody></table></div>
                <div class="title2">Hna6</div>
                <div class="plugin_content">
                <table><tbody>
<tr>
			      <td class="subtable">
			      <table border="0" cellpadding="2" cellspacing="2" >
					  <tbody>
					    <tr>
					       <td>Net Address</td>
					       <td>Netmask</td>
					       <td><input id="hna6count" name="hna6count" value="'.$data['Hna6']['count'].'" type="hidden"></td>
					    </tr>';
                        if($data['Hna6']['count'])
                        {
                            for ($it=0;$it<$data['Hna6']['count'];$it++)
                            {
                                $list.='
                               <tr>
                                <td><input type="text" class="ms_subnet" id="hna6_netaddress'.$it.'" name="hna6_netaddress'.$it.'" value="'.$data['Hna6']['netaddress'][$it].'" maxlength="15" size="15"></td>
                                <td><input type="text" class="ms_ip" id="hna6_netmask'.$it.'" name="hna6_netmask'.$it.'" value="'.$data['Hna6']['netmask'][$it].'" maxlength="15" size="15"></td>
                                <td></td>
                               </tr>
                               <tr>
                                <td><div id="hna6_netaddress'.$it.'_ms_cte"></div></td>
                                <td><div id="hna6_netmask'.$it.'_ms_cte"></div></td>
                               </tr>
                                ';
                            }
                        }
	$list.='
					    <tr>
					      <td><input type="text" class="ms_subnet" id="hna6_netaddress'.$it.'" name="hna6_netaddress'.$it.'" maxlength="39" size="15"></td>
					      <td><input type="text" class="ms_ip" id="hna6_netmask'.$it.'" name="hna6_netmask'.$it.'" maxlength="39" size="15"></td>
					      <td></td>
					    </tr>
                        <tr>
                            <td><div id="hna6_netaddress'.$it.'_ms_cte"></div></td>
                            <td><div id="hna6_netmask'.$it.'_ms_cte"></div></td>
                        </tr>
					  </tbody>
                    </table>
			      </td>
			      <td class="help_image"><img title="Info avaible" src="'.$url_plugin.'/images/info_avaible.png" onclick="alert(\'Hna6:  Hosts in a OLSR routed  network  can  announce  connecitivty  to external  networks  using HNA messages. This optionblock is used to set the IPv6 nteworks to be announced by this host. [IPv6 netaddress] [0-48] Specifies a IPv6 network to announce in HNA messages. The second value  is  the  prefix-length  of  the network address. Multiple entries can be added. To announce Internet connectivity set :: 0 \');"></td>
                   </tr>
                </tbody></table></div>
                <div class="title2">LoadPlugin olsrd_httpinfo.so.0.1</div>
                <div class="plugin_content">
                <table><tbody>
       					<tr>
       						<td>Port</td>
				    		<td><input type="text" class="ms_numerical" id="olsrd_httpinfo.so.0.1_port" name="olsrd_httpinfo.so.0.1_port"';

    		if (isset($data['LoadPlugin']['olsrd_httpinfo.so.0.1']['PlParam']['port']))
			{
				$list.='	value=\''.$data['LoadPlugin']['olsrd_httpinfo.so.0.1']['PlParam']['port'].'\' ';
			}
			$list.='maxlength="5" size="5"></td>
				       </tr>
                       <tr>
                        <td></td>
                        <td colspan="2"><div id="olsrd_httpinfo_so_0_1_port_ms_cte"></div></td>
                       </tr>
                       <tr>
       						<td>Net</td><td> ';
			if (isset($data['LoadPlugin']['olsrd_httpinfo.so.0.1']['PlParam']['Net']))
			{
				$aux1=explode(' ',$data['LoadPlugin']['olsrd_httpinfo.so.0.1']['PlParam']['Net']);
				$list.='<input type="text" class="ms_subnet" id="olsrd_httpinfo.so.0.1_net1" name="olsrd_httpinfo.so.0.1_net1" value="'.$aux1[0].'" maxlength="15" size="15">
                        </td><td>
						<input type="text" class="ms_subnet" id="olsrd_httpinfo.so.0.1_net2" name="olsrd_httpinfo.so.0.1_net2" value="'.$aux1[1].'" maxlength="15" size="15">
                        </td></tr>';
			}
			else
			{
				$list.='<input type="text" class="ms_subnet" id="olsrd_httpinfo.so.0.1_net1" name="olsrd_httpinfo.so.0.1_net1" maxlength="15" size="15">
                        </td><td>
						<input type="text" class="ms_subnet" id="olsrd_httpinfo.so.0.1_net2" name="olsrd_httpinfo.so.0.1_net2" maxlength="15" size="15">
                        </td></tr>';

			}
$list.='        <tr>
                    <td></td>
                    <td><div id="olsrd_httpinfo_so_0_1_net1_ms_cte"></div></td>
                    <td><div id="olsrd_httpinfo_so_0_1_net2_ms_cte"></div></td>
                </tr>';
			/* THIS IS COMMENTED BECAUSE WE NEED ACCESS TO OLSRD_TXTINFO.SO.0.1 SO IS NOT ALLOWED TO CHANGE IT.
			// 	olsrd_txtinfo.so.0.1
    		$list.='
    				<tr>
    					<td colspan=3 rowspan=1>LoadPlugin olsrd_txtinfo.so.0.1:</td>
    				</tr>
    				<tr>
       					<td colspan=3 rowspan=1>Net ';
			if (isset($data['LoadPlugin']['olsrd_txtinfo.so.0.1']['PlParam']['accept']))
			{
				$aux1=explode(' ',$data['LoadPlugin']['olsrd_txtinfo.so.0.1']['PlParam']['accept']);
				$list.='<input type="text" id=olsrd_txtinfo.so.0.1_net1 name=olsrd_txtinfo.so.0.1_net1 value=\''.$aux1[0].'\' maxlength="15" size="15">';
						//<input type="text" id=olsrd_txtinfo.so.0.1_net2 name=olsrd_txtinfo.so.0.1_net2 value=\''.$aux1[1].'\' maxlength="15" size="15">
			}
			else
			{
				$list.='<input type="text" id=olsrd_txtinfo.so.0.1_net1 name=olsrd_txtinfo.so.0.1_net1 maxlength="15" size="15">';
						//<input type="text" id=olsrd_txtinfo.so.0.1_net2 name=olsrd_txtinfo.so.0.1_net2 maxlength="15" size="15">
			}
			*/

			// 	olsrd_secure.so.0.5

    		$list.='
                        </tr></tbody></table></div>
                <div class="title2">LoadPlugin olsrd_secure.so.0.5</div>
                <div class="plugin_content">
                <table><tbody>
       					<tr>
       						<td colspan=3 rowspan=1>Key</td><td>
				    		<input type="text" id="olsrd_secure.so.0.5_key" name="olsrd_secure.so.0.5_key" ';

    		if (isset($data['LoadPlugin']['olsrd_secure.so.0.5']['PlParam']['pass']))
			{
				if (file_exists("/etc/olsr-secret"))
				{
					$fp2=file("/etc/olsr-secret");
					$list.=' value=\''.$fp2[0].'\' ';
				}
			}
			$list.='maxlength="16"> <span class="advice"> *  16 char needed</span></td>
                   </tr>
			  </tbody>
			</table>
			</td>			
			</tr>
		</tbody></table>
        </div></form>
        <div class="right_align">
            <input type="button" class="bsave" onclick="complex_ajax_call(\'olsr\',\'output\',\''.$section.'\',\''.$plugin.'\',\'save\')" value="save">
            <input type="button" class="bsave" onclick="complex_ajax_call(\'olsr\',\'output\',\''.$section.'\',\''.$plugin.'\',\'saveandrestart\')" value="save & Apply">
        </div>
	';
	return $list;

}
?>